<?php
/**
 * Auth Controller
 */

class AuthController {
    private $userModel;

    public function __construct() {
        $this->userModel = new User();
    }

    public function showLogin() {
        if (Auth::isLoggedIn()) {
            header('Location: /halopemko/public/index.php?action=dashboard');
            exit;
        }
        require __DIR__ . '/../views/auth/login.php';
    }

    public function login() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';

        if (empty($username) || empty($password)) {
            $_SESSION['error'] = "Username dan password harus diisi";
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        $user = $this->userModel->findByUsername($username);

        if (!$user || !$this->userModel->verifyPassword($password, $user['password'])) {
            $_SESSION['error'] = "Username atau password salah";
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        Auth::login($user);
        header('Location: /halopemko/public/index.php?action=dashboard');
        exit;
    }

    public function logout() {
        Auth::logout();
        header('Location: /halopemko/public/index.php?action=login');
        exit;
    }

    /**
     * Auto-login operator menggunakan token dari WhatsApp notification
     * Token berlaku selama 24 jam
     */
    public function operatorAutoLogin() {
        $token = $_GET['token'] ?? '';

        if (empty($token)) {
            $_SESSION['error'] = "Token tidak valid atau tidak ditemukan";
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        $operatorLoginTokenModel = new OperatorLoginToken();
        $tokenData = $operatorLoginTokenModel->validateToken($token);

        if (!$tokenData) {
            $_SESSION['error'] = "Token tidak valid atau sudah kedaluwarsa. Token berlaku selama 24 jam.";
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        // Ambil data operator
        $userModel = new User();
        $operator = $userModel->findById($tokenData['operator_id']);

        if (!$operator || $operator['role'] !== 'operator') {
            $_SESSION['error'] = "Operator tidak ditemukan atau tidak valid";
            header('Location: /halopemko/public/index.php?action=login');
            exit;
        }

        // Login operator
        Auth::login($operator);

        // Redirect ke halaman detail tiket
        header('Location: /halopemko/public/index.php?action=ticket&id=' . $tokenData['ticket_id']);
        exit;
    }
}








