<?php
/**
 * Dashboard Controller
 */

class DashboardController {
    private $ticketModel;

    public function __construct() {
        $this->ticketModel = new Ticket();
    }

    public function index() {
        Auth::requireAuth();
        $user = Auth::user();

        $stats = [];
        $tickets = [];
        $sharedPendingCount = 0;

        switch ($user['role']) {
            case 'admin':
                $stats = $this->ticketModel->getStats();
                $tickets = $this->ticketModel->getAll(['status' => $_GET['status'] ?? null]);
                $stats['total_accessible'] = $stats['total'];
                break;

            case 'operator':
                $statusFilter = $_GET['status'] ?? null;
                $stats = $this->ticketModel->getStatsByUser($user['id']);
                $sharedPendingCount = $this->ticketModel->getSharedPendingCountForOperator($user['id']);
                $stats['shared_pending'] = $sharedPendingCount;
                $stats['total_accessible'] = $stats['total'] + $sharedPendingCount;
                $tickets = $this->ticketModel->getAccessibleTicketsForOperator($user['id'], $statusFilter);
                break;

            case 'pic':
                // PIC bisa melihat tiket yang ditugaskan sebagai PIC utama atau sebagai CC
                $viewType = $_GET['view'] ?? 'all'; // all, main, cc
                
                if ($viewType === 'main') {
                    // Hanya tiket sebagai PIC utama
                    $stats = $this->ticketModel->getStatsByUser($user['id'], 'pic');
                    $tickets = $this->ticketModel->getAll([
                        'pic_id' => $user['id'],
                        'status' => $_GET['status'] ?? null
                    ]);
                } elseif ($viewType === 'cc') {
                    // Hanya tiket sebagai CC PIC
                    $stats = $this->ticketModel->getCCPICStats($user['id']);
                    $tickets = $this->ticketModel->getCCPICTickets($user['id'], $_GET['status'] ?? null);
                } else {
                    // Semua tiket (main + cc)
                    $stats = $this->ticketModel->getAllPICStats($user['id']);
                    $tickets = $this->ticketModel->getAllForPIC($user['id']);
                    
                    // Filter by status if provided
                    if (!empty($_GET['status'])) {
                        $tickets = array_filter($tickets, function($ticket) {
                            return $ticket['status'] === $_GET['status'];
                        });
                    }
                }
                $stats['total_accessible'] = $stats['total'];
                break;

            default:
                header('Location: /halopemko/public/index.php?action=login');
                exit;
        }

        if (empty($stats['total_accessible']) && isset($stats['total'])) {
            $stats['total_accessible'] = $stats['total'];
        }

        require __DIR__ . '/../views/dashboard/index.php';
    }
}

