<?php
/**
 * PIC Controller
 * Untuk manage master data PIC dengan OPD
 */

class PICController {
    private $userModel;

    public function __construct() {
        $this->userModel = new User();
    }

    /**
     * List semua PIC dengan informasi OPD
     */
    public function index() {
        Middleware::role('admin');
        $user = Auth::user();

        // Get semua PIC
        $pics = $this->userModel->getAllPICsAdmin();
        
        // Pastikan pics adalah array
        if (!is_array($pics)) {
            $pics = [];
        }
        
        // Remove duplicates berdasarkan id
        $uniquePICs = [];
        $seenIds = [];
        
        foreach ($pics as $pic) {
            if (!is_array($pic) || !isset($pic['id'])) {
                continue;
            }
            
            // Skip jika sudah ada
            if (in_array($pic['id'], $seenIds)) {
                continue;
            }
            
            $seenIds[] = $pic['id'];
            $uniquePICs[] = $pic;
        }
        
        $pics = $uniquePICs;

        require __DIR__ . '/../views/pics/index.php';
    }

    /**
     * Form create PIC
     */
    public function create() {
        Middleware::role('admin');
        $user = Auth::user();
        
        require __DIR__ . '/../views/pics/form.php';
    }

    /**
     * Store PIC baru
     */
    public function store() {
        Middleware::role('admin');

        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $name = $_POST['name'] ?? '';
        $email = $_POST['email'] ?? '';
        $phone = $_POST['phone'] ?? '';
        $opd_name = $_POST['opd_name'] ?? '';
        $kepala_opd_name = $_POST['kepala_opd_name'] ?? '';
        $kepala_opd_wa = $_POST['kepala_opd_wa'] ?? '';
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        // Validasi
        if (empty($username) || empty($password) || empty($name)) {
            $_SESSION['error'] = 'Username, password, dan nama wajib diisi';
            header('Location: /halopemko/public/index.php?action=pic_create');
            exit;
        }

        // Cek username sudah ada
        if ($this->userModel->checkUsernameExists($username)) {
            $_SESSION['error'] = 'Username sudah digunakan';
            header('Location: /halopemko/public/index.php?action=pic_create');
            exit;
        }

        // Create PIC
        $data = [
            'username' => $username,
            'password' => $password,
            'name' => $name,
            'role' => 'pic',
            'email' => $email ?: null,
            'phone' => $phone ?: null,
            'opd_name' => $opd_name ?: null,
            'kepala_opd_name' => $kepala_opd_name ?: null,
            'kepala_opd_wa' => $kepala_opd_wa ?: null,
            'is_active' => $is_active
        ];

        $this->userModel->create($data);
        
        $_SESSION['success'] = 'PIC berhasil ditambahkan';
        header('Location: /halopemko/public/index.php?action=pics');
        exit;
    }

    /**
     * Form edit PIC
     */
    public function edit() {
        Middleware::role('admin');
        $user = Auth::user();

        $id = $_GET['id'] ?? null;
        if (!$id) {
            $_SESSION['error'] = 'ID PIC tidak valid';
            header('Location: /halopemko/public/index.php?action=pics');
            exit;
        }

        $pic = $this->userModel->findById($id, true); // Include inactive for admin
        if (!$pic || $pic['role'] !== 'pic') {
            $_SESSION['error'] = 'PIC tidak ditemukan';
            header('Location: /halopemko/public/index.php?action=pics');
            exit;
        }

        require __DIR__ . '/../views/pics/form.php';
    }

    /**
     * Update PIC
     */
    public function update() {
        Middleware::role('admin');

        $id = $_POST['id'] ?? null;
        if (!$id) {
            $_SESSION['error'] = 'ID PIC tidak valid';
            header('Location: /halopemko/public/index.php?action=pics');
            exit;
        }

        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $name = $_POST['name'] ?? '';
        $email = $_POST['email'] ?? '';
        $phone = $_POST['phone'] ?? '';
        $opd_name = $_POST['opd_name'] ?? '';
        $kepala_opd_name = $_POST['kepala_opd_name'] ?? '';
        $kepala_opd_wa = $_POST['kepala_opd_wa'] ?? '';
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        // Validasi
        if (empty($username) || empty($name)) {
            $_SESSION['error'] = 'Username dan nama wajib diisi';
            header('Location: /halopemko/public/index.php?action=pic_edit&id=' . $id);
            exit;
        }

        // Cek username sudah ada (kecuali untuk user ini)
        if ($this->userModel->checkUsernameExists($username, $id)) {
            $_SESSION['error'] = 'Username sudah digunakan';
            header('Location: /halopemko/public/index.php?action=pic_edit&id=' . $id);
            exit;
        }

        // Update PIC
        $data = [
            'username' => $username,
            'name' => $name,
            'email' => $email ?: null,
            'phone' => $phone ?: null,
            'opd_name' => $opd_name ?: null,
            'kepala_opd_name' => $kepala_opd_name ?: null,
            'kepala_opd_wa' => $kepala_opd_wa ?: null,
            'is_active' => $is_active
        ];

        // Update password jika diberikan
        if (!empty($password)) {
            $data['password'] = $password;
        }

        $this->userModel->update($id, $data);
        
        $_SESSION['success'] = 'PIC berhasil diupdate';
        header('Location: /halopemko/public/index.php?action=pics');
        exit;
    }

    /**
     * Delete PIC (soft delete)
     */
    public function delete() {
        Middleware::role('admin');

        $id = $_GET['id'] ?? null;
        if (!$id) {
            $_SESSION['error'] = 'ID PIC tidak valid';
            header('Location: /halopemko/public/index.php?action=pics');
            exit;
        }

        $this->userModel->delete($id);
        
        $_SESSION['success'] = 'PIC berhasil dihapus';
        header('Location: /halopemko/public/index.php?action=pics');
        exit;
    }

}

