<?php
/**
 * Middleware Helper Class
 */

class Middleware {
    public static function auth() {
        Auth::requireAuth();
    }

    public static function role($role) {
        Auth::requireRole($role);
    }

    public static function roles($roles) {
        Auth::requireAuth();
        $user = Auth::user();
        if (!in_array($user['role'], $roles)) {
            header('Location: /halopemko/public/index.php?action=dashboard');
            exit;
        }
    }
}









