<?php
/**
 * Ticket Comment Model
 */

class TicketComment {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function create($data) {
        $sql = "INSERT INTO ticket_comments (ticket_id, user_id, comment, attachment_path, attachment_type)
                VALUES (?, ?, ?, ?, ?)";
        
        $params = [
            $data['ticket_id'],
            $data['user_id'],
            $data['comment'],
            $data['attachment_path'] ?? null,
            $data['attachment_type'] ?? null
        ];

        $this->db->query($sql, $params);
        return $this->db->lastInsertId();
    }

    public function getByTicketId($ticketId) {
        $sql = "SELECT tc.*, u.name as user_name, u.role as user_role
                FROM ticket_comments tc
                INNER JOIN users u ON tc.user_id = u.id
                WHERE tc.ticket_id = ?
                ORDER BY tc.created_at ASC";
        
        return $this->db->fetchAll($sql, [$ticketId]);
    }

    public function findById($id) {
        $sql = "SELECT tc.*, u.name as user_name, u.role as user_role
                FROM ticket_comments tc
                INNER JOIN users u ON tc.user_id = u.id
                WHERE tc.id = ?";
        
        return $this->db->fetch($sql, [$id]);
    }
}









