<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Halo Pemko Kota Langsa</title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>Halo Pemko Kota Langsa</h1>
            <p>Sistem Pengaduan Masyarakat Berbasis Tiket</p>
        </div>
    </header>

    <main class="container" style="max-width: 500px; margin: 50px auto;">
        <h2>Login</h2>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-error">
                <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="/halopemko/public/index.php?action=login_submit" class="form">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">Login</button>
                <a href="/halopemko/public/index.php" class="btn btn-secondary">Kembali</a>
            </div>
        </form>
    </main>

    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Halo Pemko Kota Langsa. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>









