<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Update Progress Pengaduan'); ?></title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
    <style>
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --surface: #ffffff;
            --surface-soft: #f8fafc;
            --text: #0f172a;
            --text-muted: #64748b;
            --border: #e2e8f0;
            --accent: #9333ea;
        }
        body.wa-progress-page {
            min-height: 100vh;
            margin: 0;
            font-family: 'Inter', sans-serif;
            color: var(--text);
            display: flex;
            justify-content: center;
            padding: 48px 16px 64px;
            background: radial-gradient(120% 120% at 10% 20%, #dbeafe 0%, rgba(219, 234, 254, 0) 45%), radial-gradient(120% 120% at 90% 10%, #ede9fe 0%, rgba(237, 233, 254, 0) 50%), linear-gradient(140deg, #f8fafc 0%, #eef2ff 50%, #f5f3ff 100%);
        }
        body.wa-progress-page::before {
            content: "";
            position: fixed;
            inset: 0;
            pointer-events: none;
            background: radial-gradient(480px at 15% 85%, rgba(129, 140, 248, 0.14), transparent 70%), radial-gradient(520px at 85% 80%, rgba(59, 130, 246, 0.18), transparent 70%);
            z-index: 0;
        }
        .wa-shell {
            position: relative;
            z-index: 1;
            max-width: 980px;
            width: 100%;
            display: grid;
            gap: 32px;
        }
        .wa-header {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: flex-start;
            gap: 22px;
            padding: 32px;
            background: linear-gradient(135deg, rgba(79, 70, 229, 0.1), rgba(56, 189, 248, 0.12));
            border-radius: 26px;
            border: 1px solid rgba(148, 163, 184, 0.16);
            box-shadow: 0 32px 80px rgba(15, 41, 77, 0.12);
            backdrop-filter: blur(14px);
        }
        .wa-header-text h1 {
            margin: 8px 0 12px;
            font-size: 1.9rem;
            letter-spacing: -0.01em;
        }
        .wa-header-text p {
            margin: 0;
            color: var(--text-muted);
            font-size: 1rem;
        }
        .wa-pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            border-radius: 999px;
            background: rgba(30, 64, 175, 0.1);
            color: #1d4ed8;
            font-weight: 600;
            font-size: 0.85rem;
        }
        .wa-ticket-chip {
            padding: 18px 24px;
            border-radius: 20px;
            background: linear-gradient(135deg, #2563eb, #7c3aed);
            color: #fff;
            display: grid;
            gap: 6px;
            min-width: 220px;
            box-shadow: 0 24px 40px rgba(37, 99, 235, 0.35);
        }
        .wa-ticket-chip .label {
            opacity: 0.75;
            font-size: 0.85rem;
        }
        .wa-ticket-chip .value {
            letter-spacing: 0.08em;
            font-weight: 700;
            font-size: 1.08rem;
        }
        .wa-alert {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 16px 20px;
            border-radius: 16px;
            font-weight: 600;
            box-shadow: 0 20px 45px rgba(15, 41, 77, 0.12);
        }
        .wa-alert svg {
            width: 20px;
            height: 20px;
        }
        .wa-alert-success {
            background: #ecfdf5;
            color: #047857;
            border: 1px solid #34d399;
        }
        .wa-alert-warn {
            background: #fff7ed;
            color: #b45309;
            border: 1px solid #fbbf24;
        }
        .wa-section {
            background: var(--surface);
            border-radius: 24px;
            padding: 32px;
            box-shadow: 0 28px 60px rgba(15, 41, 77, 0.12);
            border: 1px solid rgba(148, 163, 184, 0.16);
        }
        .wa-section h2 {
            margin: 0 0 12px;
            font-size: 1.4rem;
            letter-spacing: -0.01em;
        }
        .wa-summary {
            display: grid;
            gap: 24px;
        }
        .wa-summary-main h3 {
            margin: 0 0 10px;
            font-size: 1.25rem;
        }
        .wa-summary-main .wa-meta {
            margin: 0;
            color: var(--text-muted);
            font-size: 0.95rem;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 12px;
        }
        .wa-summary-main .wa-meta .dot {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: var(--text-muted);
        }
        .wa-summary-grid {
            display: grid;
            gap: 18px 22px;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            margin: 0;
        }
        .wa-summary-grid dt {
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            color: var(--text-muted);
            margin-bottom: 4px;
        }
        .wa-summary-grid dd {
            margin: 0;
            font-weight: 600;
        }
        .wa-summary-grid .full {
            grid-column: 1 / -1;
        }
        .wa-section-head {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 12px;
            margin-bottom: 16px;
        }
        .wa-section-sub {
            margin: 4px 0 0;
            color: var(--text-muted);
            font-size: 0.95rem;
        }
        .wa-count {
            padding: 6px 14px;
            border-radius: 999px;
            background: rgba(37, 99, 235, 0.12);
            color: var(--primary);
            font-weight: 600;
            font-size: 0.88rem;
            letter-spacing: 0.05em;
        }
        .wa-timeline {
            position: relative;
            list-style: none;
            margin: 0;
            padding: 8px 0 8px 54px;
            display: grid;
            gap: 26px;
        }
        .wa-timeline::before {
            content: "";
            position: absolute;
            left: 26px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: linear-gradient(180deg, rgba(37, 99, 235, 0.45) 0%, rgba(147, 51, 234, 0.45) 60%, rgba(255, 255, 255, 0) 100%);
        }
        .wa-timeline-item {
            position: relative;
            padding-left: 0;
        }
        .wa-timeline-icon {
            position: absolute;
            left: 18px;
            top: 24px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            border: 4px solid #fff;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%);
            box-shadow: 0 10px 20px rgba(79, 70, 229, 0.25);
        }
        .wa-timeline-content {
            background: var(--surface-soft);
            border-radius: 20px;
            padding: 22px 24px;
            border: 1px solid rgba(148,163,184,0.18);
            box-shadow: 0 28px 55px rgba(15,41,77,0.12);
            display: grid;
            gap: 16px;
            transition: transform 0.25s ease, box-shadow 0.25s ease;
        }
        .wa-timeline-content:hover {
            transform: translateY(-3px);
            box-shadow: 0 32px 65px rgba(15,41,77,0.16);
        }
        .wa-timeline-header {
            display: flex;
            align-items: center;
            gap: 16px;
        }
        .wa-timeline-avatar {
            width: 42px;
            height: 42px;
            border-radius: 14px;
            display: grid;
            place-items: center;
            font-weight: 700;
            font-size: 1.05rem;
            color: #fff;
            background: linear-gradient(135deg, #3b82f6 0%, #6366f1 60%, #9333ea 100%);
            box-shadow: 0 14px 28px rgba(99,102,241,0.28);
        }
        .wa-timeline-meta {
            display: grid;
            gap: 4px;
        }
        .wa-timeline-author {
            font-weight: 700;
            font-size: 1rem;
            color: #0f172a;
        }
        .wa-timeline-meta time {
            font-size: 0.88rem;
            color: var(--text-muted);
        }
        .wa-timeline-content p {
            margin: 0;
            line-height: 1.6;
            color: #475569;
        }
        .wa-link {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            margin-top: 12px;
            color: var(--primary);
            font-weight: 600;
            text-decoration: none;
            font-size: 0.95rem;
        }
        .wa-link:hover {
            color: var(--primary-dark);
        }
        .wa-link::after {
            content: "\203A";
            font-size: 1rem;
            transform: translateY(-1px);
        }
        .wa-empty {
            text-align: center;
            padding: 32px;
            border-radius: 18px;
            border: 1px dashed var(--border);
            color: var(--text-muted);
            background: rgba(255,255,255,0.85);
        }
        .wa-empty svg {
            width: 38px;
            height: 38px;
            margin-bottom: 12px;
        }
        .wa-grid {
            display: grid;
            gap: 26px;
        }
        @media (min-width: 900px) {
            .wa-grid {
                grid-template-columns: repeat(2, minmax(0, 1fr));
            }
        }
        .wa-card {
            background: var(--surface);
            border-radius: 20px;
            padding: 26px;
            border: 1px solid rgba(148,163,184,0.18);
            display: grid;
            gap: 18px;
            box-shadow: 0 28px 55px rgba(15,41,77,0.12);
        }
        .wa-card h3 {
            margin: 0;
            font-size: 1.15rem;
        }
        .wa-card-copy {
            margin: 0;
            color: var(--text-muted);
            line-height: 1.5;
        }
        .wa-card-disabled {
            text-align: center;
            opacity: 0.55;
        }
        .form-group {
            margin-bottom: 18px;
        }
        label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
            color: var(--text);
        }
        textarea {
            width: 100%;
            min-height: 120px;
            border-radius: 12px;
            border: 1px solid var(--border);
            padding: 12px;
            font-family: inherit;
            transition: border 0.2s ease, box-shadow 0.2s ease;
        }
        select {
            width: 100%;
            padding: 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            font-family: inherit;
            font-size: 1rem;
            background: var(--surface);
            transition: border 0.2s ease, box-shadow 0.2s ease;
            cursor: pointer;
        }
        select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(37,99,235,0.2);
        }
        textarea:focus,
        input[type="file"]:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(37,99,235,0.2);
        }
        input[type="file"] {
            width: 100%;
            padding: 10px;
            border-radius: 12px;
            border: 1px dashed var(--border);
            background: var(--surface-soft);
        }
        .hint {
            display: block;
            margin-top: 6px;
            color: var(--text-muted);
            font-size: 0.82rem;
        }
        .btn-primary,
        .btn-success {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            gap: 6px;
            padding: 12px 26px;
            border-radius: 999px;
            border: none;
            cursor: pointer;
            font-weight: 600;
            color: #fff;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .btn-primary {
            background: var(--primary);
        }
        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: 0 16px 32px rgba(37,99,235,0.25);
        }
        .btn-success {
            background: #16a34a;
        }
        .btn-success:hover {
            background: #15803d;
            transform: translateY(-1px);
            box-shadow: 0 16px 32px rgba(22,163,74,0.25);
        }
        .btn-disabled {
            padding: 12px 24px;
            border-radius: 999px;
            border: none;
            background: var(--border);
            color: var(--text-muted);
            font-weight: 600;
        }
        @media (max-width: 720px) {
            .wa-header {
                padding: 26px;
            }
            .wa-section,
            .wa-card {
                padding: 26px;
            }
            .wa-timeline {
                padding-left: 44px;
            }
            .wa-timeline::before {
                left: 18px;
            }
            .wa-timeline-icon {
                left: 10px;
            }
        }
    </style>
</head>
<body class="wa-progress-page">
    <div class="wa-shell">
        <header class="wa-header">
            <div class="wa-header-text">
                <span class="wa-pill">Halo Pemko</span>
                <h1>Update Pengaduan</h1>
                <p>Laporkan perkembangan terbaru atau tutup pengaduan langsung dari WhatsApp.</p>
            </div>
            <div class="wa-ticket-chip">
                <span class="label">Nomor Tiket</span>
                <span class="value"><?= htmlspecialchars($ticket['ticket_no'] ?? '-'); ?></span>
            </div>
        </header>

        <?php if (!empty($notice) && $notice === 'progress_success'): ?>
            <div class="wa-alert wa-alert-success">
                <svg viewBox="0 0 24 24"><path d="M5 12.5l4 4 10-10" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round"/></svg>
                <span>Progress berhasil dikirim. Terima kasih telah memperbarui pengaduan.</span>
            </div>
        <?php endif; ?>

        <section class="wa-section">
            <h2>Ringkasan Pengaduan</h2>
            <div class="wa-summary">
                <div class="wa-summary-main">
                    <h3><?= htmlspecialchars($ticket['subject'] ?? '-'); ?></h3>
                    <p class="wa-meta">
                        Status: <strong><?= htmlspecialchars(ucfirst(str_replace('_', ' ', $ticket['status'] ?? ''))); ?></strong>
                        <span class="dot"></span>
                        Prioritas: <strong><?= htmlspecialchars(ucfirst($ticket['priority'] ?? '')); ?></strong>
                    </p>
                    <?php if (!empty($ticket['description'])): ?>
                        <p class="wa-desc"><?= nl2br(htmlspecialchars($ticket['description'])); ?></p>
                    <?php endif; ?>
                </div>
                <dl class="wa-summary-grid">
                    <div>
                        <dt>Pelapor</dt>
                        <dd><?= htmlspecialchars($ticket['reporter_name'] ?? '-'); ?></dd>
                    </div>
                    <div>
                        <dt>Telepon</dt>
                        <dd><?= htmlspecialchars($ticket['reporter_phone'] ?? '-'); ?></dd>
                    </div>
                    <div>
                        <dt>Email</dt>
                        <dd><?= $ticket['reporter_email'] ? htmlspecialchars($ticket['reporter_email']) : '-'; ?></dd>
                    </div>
                    <div>
                        <dt>Tanggal Buat</dt>
                        <dd><?= !empty($ticket['created_at']) ? date('d/m/Y H:i', strtotime($ticket['created_at'])) : '-'; ?></dd>
                    </div>
                    <?php if (!empty($ticket['reporter_address'])): ?>
                        <div class="full">
                            <dt>Alamat</dt>
                            <dd><?= nl2br(htmlspecialchars($ticket['reporter_address'])); ?></dd>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($ticket['attachment_path'])): ?>
                        <div>
                            <dt>Lampiran</dt>
                            <dd><a class="wa-link" target="_blank" href="/halopemko/uploads/<?= htmlspecialchars($ticket['attachment_path']); ?>">Lihat Lampiran</a></dd>
                        </div>
                    <?php endif; ?>
                </dl>
            </div>
        </section>

        <section class="wa-section">
            <div class="wa-section-head">
                <h2>Riwayat Progress</h2>
                <?php if (!empty($comments)): ?>
                    <span class="wa-count"><?= count($comments); ?> catatan</span>
                <?php endif; ?>
            </div>
            <?php if (!empty($comments)): ?>
                <ol class="wa-timeline">
                    <?php foreach ($comments as $comment): ?>
                        <?php
                            $authorName = $comment['user_name'] ?? 'PIC';
                            if (function_exists('mb_substr')) {
                                $authorInitial = mb_strtoupper(mb_substr($authorName, 0, 1));
                            } else {
                                $authorInitial = strtoupper(substr($authorName, 0, 1));
                            }
                            $timestamp = isset($comment['created_at']) ? strtotime($comment['created_at']) : false;
                        ?>
                        <li class="wa-timeline-item">
                            <div class="wa-timeline-icon"></div>
                            <div class="wa-timeline-content">
                                <div class="wa-timeline-header">
                                    <div class="wa-timeline-avatar"><?= htmlspecialchars($authorInitial); ?></div>
                                    <div class="wa-timeline-meta">
                                        <span class="wa-timeline-author"><?= htmlspecialchars($authorName); ?></span>
                                        <time datetime="<?= $timestamp ? date('c', $timestamp) : ''; ?>">
                                            <?= $timestamp ? date('d M Y • H:i', $timestamp) : '-'; ?>
                                        </time>
                                    </div>
                                </div>
                                <p><?= nl2br(htmlspecialchars($comment['comment'] ?? '')); ?></p>
                                <?php if (!empty($comment['attachment_path'])): ?>
                                    <a class="wa-link" target="_blank" href="/halopemko/uploads/<?= htmlspecialchars($comment['attachment_path']); ?>">Lihat Bukti</a>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ol>
            <?php else: ?>
                <div class="wa-empty">
                    <svg viewBox="0 0 24 24"><path d="M5 7h14M5 12h9m-9 5h14" stroke="currentColor" stroke-width="1.6" fill="none" stroke-linecap="round"/></svg>
                    <p>Belum ada progress yang dicatat. Laporkan tindakan pertama Anda.</p>
                </div>
            <?php endif; ?>
        </section>

        <section class="wa-section">
            <h2>Update Pengaduan</h2>
            <div class="wa-card">
                <h3>Laporkan Progress atau Penyelesaian</h3>
                <p class="wa-card-copy">Pilih jenis laporan yang ingin Anda kirimkan dan lengkapi form di bawah ini.</p>
                <form method="POST" action="/halopemko/public/index.php?action=wa_submit_progress" enctype="multipart/form-data" class="wa-form" id="updateForm">
                    <input type="hidden" name="token" id="formToken" value="<?= htmlspecialchars($progressSubmitToken ?? ''); ?>">
                    <input type="hidden" name="completeToken" id="completeToken" value="<?= htmlspecialchars($completeSubmitToken ?? ''); ?>">
                    <input type="hidden" id="progressToken" value="<?= htmlspecialchars($progressSubmitToken ?? ''); ?>">
                    
                    <div class="form-group">
                        <label for="report_type">Jenis Laporan *</label>
                        <select id="report_type" name="report_type" required>
                            <option value="progress">📋 Laporan Progress</option>
                            <option value="complete">✅ Laporan Penyelesaian</option>
                        </select>
                        <small class="hint">Pilih apakah Anda ingin melaporkan progress atau menandai pengaduan sebagai selesai.</small>
                    </div>
                    
                    <div class="form-group" id="commentGroup">
                        <label for="comment" id="commentLabel">Ringkasan Progress *</label>
                        <textarea id="comment" name="comment" placeholder="Contoh: Sudah melakukan pengecekan lapangan dan menghubungi tim teknis." required></textarea>
                        <small class="hint" id="commentHint">Jelaskan tindakan yang telah dilakukan.</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="attachment" id="attachmentLabel">Foto Bukti *</label>
                        <input type="file" id="attachment" name="attachment" accept="image/jpeg,image/png,image/gif" required>
                        <small class="hint" id="attachmentHint">Ukuran maksimal 5MB (JPG/PNG/GIF).</small>
                    </div>
                    
                    <button type="submit" class="btn-primary" id="submitButton">Kirim Progress</button>
                </form>
            </div>
        </section>
        
        <script>
            (function() {
                const form = document.getElementById('updateForm');
                const reportType = document.getElementById('report_type');
                const formToken = document.getElementById('formToken');
                const completeTokenInput = form.querySelector('input[name="completeToken"]');
                const commentLabel = document.getElementById('commentLabel');
                const commentTextarea = document.getElementById('comment');
                const commentHint = document.getElementById('commentHint');
                const attachmentLabel = document.getElementById('attachmentLabel');
                const attachmentHint = document.getElementById('attachmentHint');
                const submitButton = document.getElementById('submitButton');
                
                function updateForm() {
                    const type = reportType.value;
                    
                    if (type === 'complete') {
                        form.action = '/halopemko/public/index.php?action=wa_submit_complete';
                        formToken.value = completeTokenInput.value;
                        commentLabel.innerHTML = 'Catatan Penutup <span style="color: var(--text-muted); font-weight: normal;">(Opsional)</span>';
                        commentTextarea.placeholder = 'Tambahkan catatan penutup bila diperlukan...';
                        commentTextarea.removeAttribute('required');
                        commentHint.textContent = 'Tambahkan catatan penutup jika diperlukan.';
                        attachmentLabel.textContent = 'Foto Bukti Penyelesaian *';
                        attachmentHint.textContent = 'Lampirkan bukti pekerjaan selesai (maks 5MB).';
                        submitButton.textContent = 'Laporkan Selesai';
                        submitButton.className = 'btn-success';
                    } else {
                        form.action = '/halopemko/public/index.php?action=wa_submit_progress';
                        formToken.value = document.getElementById('progressToken').value;
                        commentLabel.innerHTML = 'Ringkasan Progress *';
                        commentTextarea.placeholder = 'Contoh: Sudah melakukan pengecekan lapangan dan menghubungi tim teknis.';
                        commentTextarea.setAttribute('required', 'required');
                        commentHint.textContent = 'Jelaskan tindakan yang telah dilakukan.';
                        attachmentLabel.textContent = 'Foto Bukti Progress *';
                        attachmentHint.textContent = 'Ukuran maksimal 5MB (JPG/PNG/GIF).';
                        submitButton.textContent = 'Kirim Progress';
                        submitButton.className = 'btn-primary';
                    }
                }
                
                reportType.addEventListener('change', updateForm);
                updateForm();
            })();
        </script>
    </div>
</body>
</html>

